package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetPhoneNumberResponse(
    phoneNumber: Optional[zio.aws.chime.model.PhoneNumber] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetPhoneNumberResponse = {
    import GetPhoneNumberResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetPhoneNumberResponse
      .builder()
      .optionallyWith(phoneNumber.map(value => value.buildAwsValue()))(
        _.phoneNumber
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetPhoneNumberResponse.ReadOnly =
    zio.aws.chime.model.GetPhoneNumberResponse.wrap(buildAwsValue())
}
object GetPhoneNumberResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetPhoneNumberResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetPhoneNumberResponse =
      zio.aws.chime.model
        .GetPhoneNumberResponse(phoneNumber.map(value => value.asEditable))
    def phoneNumber: Optional[zio.aws.chime.model.PhoneNumber.ReadOnly]
    def getPhoneNumber
        : ZIO[Any, AwsError, zio.aws.chime.model.PhoneNumber.ReadOnly] =
      AwsError.unwrapOptionField("phoneNumber", phoneNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetPhoneNumberResponse
  ) extends zio.aws.chime.model.GetPhoneNumberResponse.ReadOnly {
    override val phoneNumber
        : Optional[zio.aws.chime.model.PhoneNumber.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumber())
        .map(value => zio.aws.chime.model.PhoneNumber.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetPhoneNumberResponse
  ): zio.aws.chime.model.GetPhoneNumberResponse.ReadOnly = new Wrapper(impl)
}
