package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString128
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetProxySessionRequest(
    voiceConnectorId: NonEmptyString128,
    proxySessionId: NonEmptyString128
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetProxySessionRequest = {
    import GetProxySessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetProxySessionRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString128.unwrap(voiceConnectorId): java.lang.String
      )
      .proxySessionId(
        NonEmptyString128.unwrap(proxySessionId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetProxySessionRequest.ReadOnly =
    zio.aws.chime.model.GetProxySessionRequest.wrap(buildAwsValue())
}
object GetProxySessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetProxySessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetProxySessionRequest =
      zio.aws.chime.model
        .GetProxySessionRequest(voiceConnectorId, proxySessionId)
    def voiceConnectorId: NonEmptyString128
    def proxySessionId: NonEmptyString128
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString128] =
      ZIO.succeed(voiceConnectorId)
    def getProxySessionId: ZIO[Any, Nothing, NonEmptyString128] =
      ZIO.succeed(proxySessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetProxySessionRequest
  ) extends zio.aws.chime.model.GetProxySessionRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString128 =
      zio.aws.chime.model.primitives.NonEmptyString128(impl.voiceConnectorId())
    override val proxySessionId: NonEmptyString128 =
      zio.aws.chime.model.primitives.NonEmptyString128(impl.proxySessionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetProxySessionRequest
  ): zio.aws.chime.model.GetProxySessionRequest.ReadOnly = new Wrapper(impl)
}
