package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetProxySessionResponse(
    proxySession: Optional[zio.aws.chime.model.ProxySession] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetProxySessionResponse = {
    import GetProxySessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetProxySessionResponse
      .builder()
      .optionallyWith(proxySession.map(value => value.buildAwsValue()))(
        _.proxySession
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetProxySessionResponse.ReadOnly =
    zio.aws.chime.model.GetProxySessionResponse.wrap(buildAwsValue())
}
object GetProxySessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetProxySessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetProxySessionResponse =
      zio.aws.chime.model
        .GetProxySessionResponse(proxySession.map(value => value.asEditable))
    def proxySession: Optional[zio.aws.chime.model.ProxySession.ReadOnly]
    def getProxySession
        : ZIO[Any, AwsError, zio.aws.chime.model.ProxySession.ReadOnly] =
      AwsError.unwrapOptionField("proxySession", proxySession)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetProxySessionResponse
  ) extends zio.aws.chime.model.GetProxySessionResponse.ReadOnly {
    override val proxySession
        : Optional[zio.aws.chime.model.ProxySession.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.proxySession())
        .map(value => zio.aws.chime.model.ProxySession.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetProxySessionResponse
  ): zio.aws.chime.model.GetProxySessionResponse.ReadOnly = new Wrapper(impl)
}
