package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetRetentionSettingsRequest(accountId: NonEmptyString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetRetentionSettingsRequest = {
    import GetRetentionSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetRetentionSettingsRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetRetentionSettingsRequest.ReadOnly =
    zio.aws.chime.model.GetRetentionSettingsRequest.wrap(buildAwsValue())
}
object GetRetentionSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetRetentionSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetRetentionSettingsRequest =
      zio.aws.chime.model.GetRetentionSettingsRequest(accountId)
    def accountId: NonEmptyString
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetRetentionSettingsRequest
  ) extends zio.aws.chime.model.GetRetentionSettingsRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetRetentionSettingsRequest
  ): zio.aws.chime.model.GetRetentionSettingsRequest.ReadOnly = new Wrapper(
    impl
  )
}
