package zio.aws.chime.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.Iso8601Timestamp
import scala.jdk.CollectionConverters._
final case class GetRetentionSettingsResponse(
    retentionSettings: Optional[zio.aws.chime.model.RetentionSettings] =
      Optional.Absent,
    initiateDeletionTimestamp: Optional[Iso8601Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetRetentionSettingsResponse = {
    import GetRetentionSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetRetentionSettingsResponse
      .builder()
      .optionallyWith(retentionSettings.map(value => value.buildAwsValue()))(
        _.retentionSettings
      )
      .optionallyWith(
        initiateDeletionTimestamp.map(value =>
          Iso8601Timestamp.unwrap(value): Instant
        )
      )(_.initiateDeletionTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetRetentionSettingsResponse.ReadOnly =
    zio.aws.chime.model.GetRetentionSettingsResponse.wrap(buildAwsValue())
}
object GetRetentionSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetRetentionSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetRetentionSettingsResponse =
      zio.aws.chime.model.GetRetentionSettingsResponse(
        retentionSettings.map(value => value.asEditable),
        initiateDeletionTimestamp.map(value => value)
      )
    def retentionSettings
        : Optional[zio.aws.chime.model.RetentionSettings.ReadOnly]
    def initiateDeletionTimestamp: Optional[Iso8601Timestamp]
    def getRetentionSettings
        : ZIO[Any, AwsError, zio.aws.chime.model.RetentionSettings.ReadOnly] =
      AwsError.unwrapOptionField("retentionSettings", retentionSettings)
    def getInitiateDeletionTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField(
        "initiateDeletionTimestamp",
        initiateDeletionTimestamp
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetRetentionSettingsResponse
  ) extends zio.aws.chime.model.GetRetentionSettingsResponse.ReadOnly {
    override val retentionSettings
        : Optional[zio.aws.chime.model.RetentionSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retentionSettings())
        .map(value => zio.aws.chime.model.RetentionSettings.wrap(value))
    override val initiateDeletionTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.initiateDeletionTimestamp())
        .map(value => zio.aws.chime.model.primitives.Iso8601Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetRetentionSettingsResponse
  ): zio.aws.chime.model.GetRetentionSettingsResponse.ReadOnly = new Wrapper(
    impl
  )
}
