package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetRoomRequest(
    accountId: NonEmptyString,
    roomId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetRoomRequest = {
    import GetRoomRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetRoomRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .roomId(NonEmptyString.unwrap(roomId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetRoomRequest.ReadOnly =
    zio.aws.chime.model.GetRoomRequest.wrap(buildAwsValue())
}
object GetRoomRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetRoomRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetRoomRequest =
      zio.aws.chime.model.GetRoomRequest(accountId, roomId)
    def accountId: NonEmptyString
    def roomId: NonEmptyString
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
    def getRoomId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(roomId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetRoomRequest
  ) extends zio.aws.chime.model.GetRoomRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
    override val roomId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.roomId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetRoomRequest
  ): zio.aws.chime.model.GetRoomRequest.ReadOnly = new Wrapper(impl)
}
