package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetSipMediaApplicationLoggingConfigurationRequest(
    sipMediaApplicationId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetSipMediaApplicationLoggingConfigurationRequest = {
    import GetSipMediaApplicationLoggingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetSipMediaApplicationLoggingConfigurationRequest
      .builder()
      .sipMediaApplicationId(
        NonEmptyString.unwrap(sipMediaApplicationId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.GetSipMediaApplicationLoggingConfigurationRequest.ReadOnly =
    zio.aws.chime.model.GetSipMediaApplicationLoggingConfigurationRequest
      .wrap(buildAwsValue())
}
object GetSipMediaApplicationLoggingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetSipMediaApplicationLoggingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.GetSipMediaApplicationLoggingConfigurationRequest =
      zio.aws.chime.model.GetSipMediaApplicationLoggingConfigurationRequest(
        sipMediaApplicationId
      )
    def sipMediaApplicationId: NonEmptyString
    def getSipMediaApplicationId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(sipMediaApplicationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetSipMediaApplicationLoggingConfigurationRequest
  ) extends zio.aws.chime.model.GetSipMediaApplicationLoggingConfigurationRequest.ReadOnly {
    override val sipMediaApplicationId: NonEmptyString =
      zio.aws.chime.model.primitives
        .NonEmptyString(impl.sipMediaApplicationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetSipMediaApplicationLoggingConfigurationRequest
  ): zio.aws.chime.model.GetSipMediaApplicationLoggingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
