package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetSipMediaApplicationLoggingConfigurationResponse(
    sipMediaApplicationLoggingConfiguration: Optional[
      zio.aws.chime.model.SipMediaApplicationLoggingConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetSipMediaApplicationLoggingConfigurationResponse = {
    import GetSipMediaApplicationLoggingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetSipMediaApplicationLoggingConfigurationResponse
      .builder()
      .optionallyWith(
        sipMediaApplicationLoggingConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.sipMediaApplicationLoggingConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.GetSipMediaApplicationLoggingConfigurationResponse.ReadOnly =
    zio.aws.chime.model.GetSipMediaApplicationLoggingConfigurationResponse
      .wrap(buildAwsValue())
}
object GetSipMediaApplicationLoggingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetSipMediaApplicationLoggingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.GetSipMediaApplicationLoggingConfigurationResponse =
      zio.aws.chime.model.GetSipMediaApplicationLoggingConfigurationResponse(
        sipMediaApplicationLoggingConfiguration.map(value => value.asEditable)
      )
    def sipMediaApplicationLoggingConfiguration: Optional[
      zio.aws.chime.model.SipMediaApplicationLoggingConfiguration.ReadOnly
    ]
    def getSipMediaApplicationLoggingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.SipMediaApplicationLoggingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sipMediaApplicationLoggingConfiguration",
      sipMediaApplicationLoggingConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetSipMediaApplicationLoggingConfigurationResponse
  ) extends zio.aws.chime.model.GetSipMediaApplicationLoggingConfigurationResponse.ReadOnly {
    override val sipMediaApplicationLoggingConfiguration: Optional[
      zio.aws.chime.model.SipMediaApplicationLoggingConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sipMediaApplicationLoggingConfiguration())
      .map(value =>
        zio.aws.chime.model.SipMediaApplicationLoggingConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetSipMediaApplicationLoggingConfigurationResponse
  ): zio.aws.chime.model.GetSipMediaApplicationLoggingConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
