package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetSipMediaApplicationRequest(
    sipMediaApplicationId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetSipMediaApplicationRequest = {
    import GetSipMediaApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetSipMediaApplicationRequest
      .builder()
      .sipMediaApplicationId(
        NonEmptyString.unwrap(sipMediaApplicationId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetSipMediaApplicationRequest.ReadOnly =
    zio.aws.chime.model.GetSipMediaApplicationRequest.wrap(buildAwsValue())
}
object GetSipMediaApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetSipMediaApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetSipMediaApplicationRequest =
      zio.aws.chime.model.GetSipMediaApplicationRequest(sipMediaApplicationId)
    def sipMediaApplicationId: NonEmptyString
    def getSipMediaApplicationId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(sipMediaApplicationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetSipMediaApplicationRequest
  ) extends zio.aws.chime.model.GetSipMediaApplicationRequest.ReadOnly {
    override val sipMediaApplicationId: NonEmptyString =
      zio.aws.chime.model.primitives
        .NonEmptyString(impl.sipMediaApplicationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetSipMediaApplicationRequest
  ): zio.aws.chime.model.GetSipMediaApplicationRequest.ReadOnly = new Wrapper(
    impl
  )
}
