package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetSipRuleRequest(sipRuleId: NonEmptyString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetSipRuleRequest = {
    import GetSipRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetSipRuleRequest
      .builder()
      .sipRuleId(NonEmptyString.unwrap(sipRuleId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetSipRuleRequest.ReadOnly =
    zio.aws.chime.model.GetSipRuleRequest.wrap(buildAwsValue())
}
object GetSipRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetSipRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetSipRuleRequest =
      zio.aws.chime.model.GetSipRuleRequest(sipRuleId)
    def sipRuleId: NonEmptyString
    def getSipRuleId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(sipRuleId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetSipRuleRequest
  ) extends zio.aws.chime.model.GetSipRuleRequest.ReadOnly {
    override val sipRuleId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.sipRuleId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetSipRuleRequest
  ): zio.aws.chime.model.GetSipRuleRequest.ReadOnly = new Wrapper(impl)
}
