package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetSipRuleResponse(
    sipRule: Optional[zio.aws.chime.model.SipRule] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetSipRuleResponse = {
    import GetSipRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetSipRuleResponse
      .builder()
      .optionallyWith(sipRule.map(value => value.buildAwsValue()))(_.sipRule)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetSipRuleResponse.ReadOnly =
    zio.aws.chime.model.GetSipRuleResponse.wrap(buildAwsValue())
}
object GetSipRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetSipRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetSipRuleResponse = zio.aws.chime.model
      .GetSipRuleResponse(sipRule.map(value => value.asEditable))
    def sipRule: Optional[zio.aws.chime.model.SipRule.ReadOnly]
    def getSipRule: ZIO[Any, AwsError, zio.aws.chime.model.SipRule.ReadOnly] =
      AwsError.unwrapOptionField("sipRule", sipRule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetSipRuleResponse
  ) extends zio.aws.chime.model.GetSipRuleResponse.ReadOnly {
    override val sipRule: Optional[zio.aws.chime.model.SipRule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sipRule())
        .map(value => zio.aws.chime.model.SipRule.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetSipRuleResponse
  ): zio.aws.chime.model.GetSipRuleResponse.ReadOnly = new Wrapper(impl)
}
