package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetUserRequest(
    accountId: NonEmptyString,
    userId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetUserRequest = {
    import GetUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetUserRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .userId(NonEmptyString.unwrap(userId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetUserRequest.ReadOnly =
    zio.aws.chime.model.GetUserRequest.wrap(buildAwsValue())
}
object GetUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetUserRequest =
      zio.aws.chime.model.GetUserRequest(accountId, userId)
    def accountId: NonEmptyString
    def userId: NonEmptyString
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
    def getUserId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetUserRequest
  ) extends zio.aws.chime.model.GetUserRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
    override val userId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.userId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetUserRequest
  ): zio.aws.chime.model.GetUserRequest.ReadOnly = new Wrapper(impl)
}
