package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetUserResponse(
    user: Optional[zio.aws.chime.model.User] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetUserResponse = {
    import GetUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetUserResponse
      .builder()
      .optionallyWith(user.map(value => value.buildAwsValue()))(_.user)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetUserResponse.ReadOnly =
    zio.aws.chime.model.GetUserResponse.wrap(buildAwsValue())
}
object GetUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetUserResponse =
      zio.aws.chime.model.GetUserResponse(user.map(value => value.asEditable))
    def user: Optional[zio.aws.chime.model.User.ReadOnly]
    def getUser: ZIO[Any, AwsError, zio.aws.chime.model.User.ReadOnly] =
      AwsError.unwrapOptionField("user", user)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetUserResponse
  ) extends zio.aws.chime.model.GetUserResponse.ReadOnly {
    override val user: Optional[zio.aws.chime.model.User.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.user())
        .map(value => zio.aws.chime.model.User.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetUserResponse
  ): zio.aws.chime.model.GetUserResponse.ReadOnly = new Wrapper(impl)
}
