package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetUserSettingsRequest(accountId: String, userId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetUserSettingsRequest = {
    import GetUserSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetUserSettingsRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .userId(userId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetUserSettingsRequest.ReadOnly =
    zio.aws.chime.model.GetUserSettingsRequest.wrap(buildAwsValue())
}
object GetUserSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetUserSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetUserSettingsRequest =
      zio.aws.chime.model.GetUserSettingsRequest(accountId, userId)
    def accountId: String
    def userId: String
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getUserId: ZIO[Any, Nothing, String] = ZIO.succeed(userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetUserSettingsRequest
  ) extends zio.aws.chime.model.GetUserSettingsRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
    override val userId: String = impl.userId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetUserSettingsRequest
  ): zio.aws.chime.model.GetUserSettingsRequest.ReadOnly = new Wrapper(impl)
}
