package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetUserSettingsResponse(
    userSettings: Optional[zio.aws.chime.model.UserSettings] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetUserSettingsResponse = {
    import GetUserSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetUserSettingsResponse
      .builder()
      .optionallyWith(userSettings.map(value => value.buildAwsValue()))(
        _.userSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetUserSettingsResponse.ReadOnly =
    zio.aws.chime.model.GetUserSettingsResponse.wrap(buildAwsValue())
}
object GetUserSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetUserSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetUserSettingsResponse =
      zio.aws.chime.model
        .GetUserSettingsResponse(userSettings.map(value => value.asEditable))
    def userSettings: Optional[zio.aws.chime.model.UserSettings.ReadOnly]
    def getUserSettings
        : ZIO[Any, AwsError, zio.aws.chime.model.UserSettings.ReadOnly] =
      AwsError.unwrapOptionField("userSettings", userSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetUserSettingsResponse
  ) extends zio.aws.chime.model.GetUserSettingsResponse.ReadOnly {
    override val userSettings
        : Optional[zio.aws.chime.model.UserSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userSettings())
        .map(value => zio.aws.chime.model.UserSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetUserSettingsResponse
  ): zio.aws.chime.model.GetUserSettingsResponse.ReadOnly = new Wrapper(impl)
}
