package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetVoiceConnectorEmergencyCallingConfigurationResponse(
    emergencyCallingConfiguration: Optional[
      zio.aws.chime.model.EmergencyCallingConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetVoiceConnectorEmergencyCallingConfigurationResponse = {
    import GetVoiceConnectorEmergencyCallingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetVoiceConnectorEmergencyCallingConfigurationResponse
      .builder()
      .optionallyWith(
        emergencyCallingConfiguration.map(value => value.buildAwsValue())
      )(_.emergencyCallingConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.GetVoiceConnectorEmergencyCallingConfigurationResponse.ReadOnly =
    zio.aws.chime.model.GetVoiceConnectorEmergencyCallingConfigurationResponse
      .wrap(buildAwsValue())
}
object GetVoiceConnectorEmergencyCallingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetVoiceConnectorEmergencyCallingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.GetVoiceConnectorEmergencyCallingConfigurationResponse =
      zio.aws.chime.model
        .GetVoiceConnectorEmergencyCallingConfigurationResponse(
          emergencyCallingConfiguration.map(value => value.asEditable)
        )
    def emergencyCallingConfiguration
        : Optional[zio.aws.chime.model.EmergencyCallingConfiguration.ReadOnly]
    def getEmergencyCallingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.EmergencyCallingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "emergencyCallingConfiguration",
      emergencyCallingConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetVoiceConnectorEmergencyCallingConfigurationResponse
  ) extends zio.aws.chime.model.GetVoiceConnectorEmergencyCallingConfigurationResponse.ReadOnly {
    override val emergencyCallingConfiguration
        : Optional[zio.aws.chime.model.EmergencyCallingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.emergencyCallingConfiguration())
        .map(value =>
          zio.aws.chime.model.EmergencyCallingConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetVoiceConnectorEmergencyCallingConfigurationResponse
  ): zio.aws.chime.model.GetVoiceConnectorEmergencyCallingConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
