package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetVoiceConnectorGroupRequest(
    voiceConnectorGroupId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetVoiceConnectorGroupRequest = {
    import GetVoiceConnectorGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetVoiceConnectorGroupRequest
      .builder()
      .voiceConnectorGroupId(
        NonEmptyString.unwrap(voiceConnectorGroupId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetVoiceConnectorGroupRequest.ReadOnly =
    zio.aws.chime.model.GetVoiceConnectorGroupRequest.wrap(buildAwsValue())
}
object GetVoiceConnectorGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetVoiceConnectorGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetVoiceConnectorGroupRequest =
      zio.aws.chime.model.GetVoiceConnectorGroupRequest(voiceConnectorGroupId)
    def voiceConnectorGroupId: NonEmptyString
    def getVoiceConnectorGroupId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetVoiceConnectorGroupRequest
  ) extends zio.aws.chime.model.GetVoiceConnectorGroupRequest.ReadOnly {
    override val voiceConnectorGroupId: NonEmptyString =
      zio.aws.chime.model.primitives
        .NonEmptyString(impl.voiceConnectorGroupId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetVoiceConnectorGroupRequest
  ): zio.aws.chime.model.GetVoiceConnectorGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
