package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetVoiceConnectorLoggingConfigurationRequest(
    voiceConnectorId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetVoiceConnectorLoggingConfigurationRequest = {
    import GetVoiceConnectorLoggingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetVoiceConnectorLoggingConfigurationRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.GetVoiceConnectorLoggingConfigurationRequest.ReadOnly =
    zio.aws.chime.model.GetVoiceConnectorLoggingConfigurationRequest
      .wrap(buildAwsValue())
}
object GetVoiceConnectorLoggingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetVoiceConnectorLoggingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.GetVoiceConnectorLoggingConfigurationRequest =
      zio.aws.chime.model
        .GetVoiceConnectorLoggingConfigurationRequest(voiceConnectorId)
    def voiceConnectorId: NonEmptyString
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetVoiceConnectorLoggingConfigurationRequest
  ) extends zio.aws.chime.model.GetVoiceConnectorLoggingConfigurationRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.voiceConnectorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetVoiceConnectorLoggingConfigurationRequest
  ): zio.aws.chime.model.GetVoiceConnectorLoggingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
