package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetVoiceConnectorLoggingConfigurationResponse(
    loggingConfiguration: Optional[zio.aws.chime.model.LoggingConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetVoiceConnectorLoggingConfigurationResponse = {
    import GetVoiceConnectorLoggingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetVoiceConnectorLoggingConfigurationResponse
      .builder()
      .optionallyWith(loggingConfiguration.map(value => value.buildAwsValue()))(
        _.loggingConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.GetVoiceConnectorLoggingConfigurationResponse.ReadOnly =
    zio.aws.chime.model.GetVoiceConnectorLoggingConfigurationResponse
      .wrap(buildAwsValue())
}
object GetVoiceConnectorLoggingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetVoiceConnectorLoggingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.GetVoiceConnectorLoggingConfigurationResponse =
      zio.aws.chime.model.GetVoiceConnectorLoggingConfigurationResponse(
        loggingConfiguration.map(value => value.asEditable)
      )
    def loggingConfiguration
        : Optional[zio.aws.chime.model.LoggingConfiguration.ReadOnly]
    def getLoggingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.LoggingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("loggingConfiguration", loggingConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetVoiceConnectorLoggingConfigurationResponse
  ) extends zio.aws.chime.model.GetVoiceConnectorLoggingConfigurationResponse.ReadOnly {
    override val loggingConfiguration
        : Optional[zio.aws.chime.model.LoggingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loggingConfiguration())
        .map(value => zio.aws.chime.model.LoggingConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetVoiceConnectorLoggingConfigurationResponse
  ): zio.aws.chime.model.GetVoiceConnectorLoggingConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
