package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString128
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetVoiceConnectorProxyRequest(
    voiceConnectorId: NonEmptyString128
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetVoiceConnectorProxyRequest = {
    import GetVoiceConnectorProxyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetVoiceConnectorProxyRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString128.unwrap(voiceConnectorId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetVoiceConnectorProxyRequest.ReadOnly =
    zio.aws.chime.model.GetVoiceConnectorProxyRequest.wrap(buildAwsValue())
}
object GetVoiceConnectorProxyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetVoiceConnectorProxyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetVoiceConnectorProxyRequest =
      zio.aws.chime.model.GetVoiceConnectorProxyRequest(voiceConnectorId)
    def voiceConnectorId: NonEmptyString128
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString128] =
      ZIO.succeed(voiceConnectorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetVoiceConnectorProxyRequest
  ) extends zio.aws.chime.model.GetVoiceConnectorProxyRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString128 =
      zio.aws.chime.model.primitives.NonEmptyString128(impl.voiceConnectorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetVoiceConnectorProxyRequest
  ): zio.aws.chime.model.GetVoiceConnectorProxyRequest.ReadOnly = new Wrapper(
    impl
  )
}
