package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetVoiceConnectorProxyResponse(
    proxy: Optional[zio.aws.chime.model.Proxy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetVoiceConnectorProxyResponse = {
    import GetVoiceConnectorProxyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetVoiceConnectorProxyResponse
      .builder()
      .optionallyWith(proxy.map(value => value.buildAwsValue()))(_.proxy)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetVoiceConnectorProxyResponse.ReadOnly =
    zio.aws.chime.model.GetVoiceConnectorProxyResponse.wrap(buildAwsValue())
}
object GetVoiceConnectorProxyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetVoiceConnectorProxyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetVoiceConnectorProxyResponse =
      zio.aws.chime.model
        .GetVoiceConnectorProxyResponse(proxy.map(value => value.asEditable))
    def proxy: Optional[zio.aws.chime.model.Proxy.ReadOnly]
    def getProxy: ZIO[Any, AwsError, zio.aws.chime.model.Proxy.ReadOnly] =
      AwsError.unwrapOptionField("proxy", proxy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetVoiceConnectorProxyResponse
  ) extends zio.aws.chime.model.GetVoiceConnectorProxyResponse.ReadOnly {
    override val proxy: Optional[zio.aws.chime.model.Proxy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.proxy())
        .map(value => zio.aws.chime.model.Proxy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetVoiceConnectorProxyResponse
  ): zio.aws.chime.model.GetVoiceConnectorProxyResponse.ReadOnly = new Wrapper(
    impl
  )
}
