package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetVoiceConnectorRequest(voiceConnectorId: NonEmptyString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetVoiceConnectorRequest = {
    import GetVoiceConnectorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetVoiceConnectorRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetVoiceConnectorRequest.ReadOnly =
    zio.aws.chime.model.GetVoiceConnectorRequest.wrap(buildAwsValue())
}
object GetVoiceConnectorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetVoiceConnectorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetVoiceConnectorRequest =
      zio.aws.chime.model.GetVoiceConnectorRequest(voiceConnectorId)
    def voiceConnectorId: NonEmptyString
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetVoiceConnectorRequest
  ) extends zio.aws.chime.model.GetVoiceConnectorRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.voiceConnectorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetVoiceConnectorRequest
  ): zio.aws.chime.model.GetVoiceConnectorRequest.ReadOnly = new Wrapper(impl)
}
