package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetVoiceConnectorResponse(
    voiceConnector: Optional[zio.aws.chime.model.VoiceConnector] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetVoiceConnectorResponse = {
    import GetVoiceConnectorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetVoiceConnectorResponse
      .builder()
      .optionallyWith(voiceConnector.map(value => value.buildAwsValue()))(
        _.voiceConnector
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetVoiceConnectorResponse.ReadOnly =
    zio.aws.chime.model.GetVoiceConnectorResponse.wrap(buildAwsValue())
}
object GetVoiceConnectorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetVoiceConnectorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetVoiceConnectorResponse =
      zio.aws.chime.model.GetVoiceConnectorResponse(
        voiceConnector.map(value => value.asEditable)
      )
    def voiceConnector: Optional[zio.aws.chime.model.VoiceConnector.ReadOnly]
    def getVoiceConnector
        : ZIO[Any, AwsError, zio.aws.chime.model.VoiceConnector.ReadOnly] =
      AwsError.unwrapOptionField("voiceConnector", voiceConnector)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetVoiceConnectorResponse
  ) extends zio.aws.chime.model.GetVoiceConnectorResponse.ReadOnly {
    override val voiceConnector
        : Optional[zio.aws.chime.model.VoiceConnector.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceConnector())
        .map(value => zio.aws.chime.model.VoiceConnector.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetVoiceConnectorResponse
  ): zio.aws.chime.model.GetVoiceConnectorResponse.ReadOnly = new Wrapper(impl)
}
