package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetVoiceConnectorStreamingConfigurationRequest(
    voiceConnectorId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetVoiceConnectorStreamingConfigurationRequest = {
    import GetVoiceConnectorStreamingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetVoiceConnectorStreamingConfigurationRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.GetVoiceConnectorStreamingConfigurationRequest.ReadOnly =
    zio.aws.chime.model.GetVoiceConnectorStreamingConfigurationRequest
      .wrap(buildAwsValue())
}
object GetVoiceConnectorStreamingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetVoiceConnectorStreamingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.GetVoiceConnectorStreamingConfigurationRequest =
      zio.aws.chime.model
        .GetVoiceConnectorStreamingConfigurationRequest(voiceConnectorId)
    def voiceConnectorId: NonEmptyString
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetVoiceConnectorStreamingConfigurationRequest
  ) extends zio.aws.chime.model.GetVoiceConnectorStreamingConfigurationRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.voiceConnectorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetVoiceConnectorStreamingConfigurationRequest
  ): zio.aws.chime.model.GetVoiceConnectorStreamingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
