package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetVoiceConnectorStreamingConfigurationResponse(
    streamingConfiguration: Optional[
      zio.aws.chime.model.StreamingConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetVoiceConnectorStreamingConfigurationResponse = {
    import GetVoiceConnectorStreamingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetVoiceConnectorStreamingConfigurationResponse
      .builder()
      .optionallyWith(
        streamingConfiguration.map(value => value.buildAwsValue())
      )(_.streamingConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.GetVoiceConnectorStreamingConfigurationResponse.ReadOnly =
    zio.aws.chime.model.GetVoiceConnectorStreamingConfigurationResponse
      .wrap(buildAwsValue())
}
object GetVoiceConnectorStreamingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetVoiceConnectorStreamingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.GetVoiceConnectorStreamingConfigurationResponse =
      zio.aws.chime.model.GetVoiceConnectorStreamingConfigurationResponse(
        streamingConfiguration.map(value => value.asEditable)
      )
    def streamingConfiguration
        : Optional[zio.aws.chime.model.StreamingConfiguration.ReadOnly]
    def getStreamingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.StreamingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "streamingConfiguration",
      streamingConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetVoiceConnectorStreamingConfigurationResponse
  ) extends zio.aws.chime.model.GetVoiceConnectorStreamingConfigurationResponse.ReadOnly {
    override val streamingConfiguration
        : Optional[zio.aws.chime.model.StreamingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamingConfiguration())
        .map(value => zio.aws.chime.model.StreamingConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetVoiceConnectorStreamingConfigurationResponse
  ): zio.aws.chime.model.GetVoiceConnectorStreamingConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
