package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetVoiceConnectorTerminationHealthRequest(
    voiceConnectorId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetVoiceConnectorTerminationHealthRequest = {
    import GetVoiceConnectorTerminationHealthRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetVoiceConnectorTerminationHealthRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.GetVoiceConnectorTerminationHealthRequest.ReadOnly =
    zio.aws.chime.model.GetVoiceConnectorTerminationHealthRequest
      .wrap(buildAwsValue())
}
object GetVoiceConnectorTerminationHealthRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetVoiceConnectorTerminationHealthRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.GetVoiceConnectorTerminationHealthRequest =
      zio.aws.chime.model
        .GetVoiceConnectorTerminationHealthRequest(voiceConnectorId)
    def voiceConnectorId: NonEmptyString
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetVoiceConnectorTerminationHealthRequest
  ) extends zio.aws.chime.model.GetVoiceConnectorTerminationHealthRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.voiceConnectorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetVoiceConnectorTerminationHealthRequest
  ): zio.aws.chime.model.GetVoiceConnectorTerminationHealthRequest.ReadOnly =
    new Wrapper(impl)
}
