package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetVoiceConnectorTerminationHealthResponse(
    terminationHealth: Optional[zio.aws.chime.model.TerminationHealth] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetVoiceConnectorTerminationHealthResponse = {
    import GetVoiceConnectorTerminationHealthResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetVoiceConnectorTerminationHealthResponse
      .builder()
      .optionallyWith(terminationHealth.map(value => value.buildAwsValue()))(
        _.terminationHealth
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.GetVoiceConnectorTerminationHealthResponse.ReadOnly =
    zio.aws.chime.model.GetVoiceConnectorTerminationHealthResponse
      .wrap(buildAwsValue())
}
object GetVoiceConnectorTerminationHealthResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetVoiceConnectorTerminationHealthResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.GetVoiceConnectorTerminationHealthResponse =
      zio.aws.chime.model.GetVoiceConnectorTerminationHealthResponse(
        terminationHealth.map(value => value.asEditable)
      )
    def terminationHealth
        : Optional[zio.aws.chime.model.TerminationHealth.ReadOnly]
    def getTerminationHealth
        : ZIO[Any, AwsError, zio.aws.chime.model.TerminationHealth.ReadOnly] =
      AwsError.unwrapOptionField("terminationHealth", terminationHealth)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetVoiceConnectorTerminationHealthResponse
  ) extends zio.aws.chime.model.GetVoiceConnectorTerminationHealthResponse.ReadOnly {
    override val terminationHealth
        : Optional[zio.aws.chime.model.TerminationHealth.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.terminationHealth())
        .map(value => zio.aws.chime.model.TerminationHealth.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetVoiceConnectorTerminationHealthResponse
  ): zio.aws.chime.model.GetVoiceConnectorTerminationHealthResponse.ReadOnly =
    new Wrapper(impl)
}
