package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetVoiceConnectorTerminationRequest(
    voiceConnectorId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetVoiceConnectorTerminationRequest = {
    import GetVoiceConnectorTerminationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetVoiceConnectorTerminationRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.GetVoiceConnectorTerminationRequest.ReadOnly =
    zio.aws.chime.model.GetVoiceConnectorTerminationRequest
      .wrap(buildAwsValue())
}
object GetVoiceConnectorTerminationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetVoiceConnectorTerminationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetVoiceConnectorTerminationRequest =
      zio.aws.chime.model.GetVoiceConnectorTerminationRequest(voiceConnectorId)
    def voiceConnectorId: NonEmptyString
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetVoiceConnectorTerminationRequest
  ) extends zio.aws.chime.model.GetVoiceConnectorTerminationRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.voiceConnectorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetVoiceConnectorTerminationRequest
  ): zio.aws.chime.model.GetVoiceConnectorTerminationRequest.ReadOnly =
    new Wrapper(impl)
}
