package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetVoiceConnectorTerminationResponse(
    termination: Optional[zio.aws.chime.model.Termination] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetVoiceConnectorTerminationResponse = {
    import GetVoiceConnectorTerminationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetVoiceConnectorTerminationResponse
      .builder()
      .optionallyWith(termination.map(value => value.buildAwsValue()))(
        _.termination
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.GetVoiceConnectorTerminationResponse.ReadOnly =
    zio.aws.chime.model.GetVoiceConnectorTerminationResponse
      .wrap(buildAwsValue())
}
object GetVoiceConnectorTerminationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetVoiceConnectorTerminationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetVoiceConnectorTerminationResponse =
      zio.aws.chime.model.GetVoiceConnectorTerminationResponse(
        termination.map(value => value.asEditable)
      )
    def termination: Optional[zio.aws.chime.model.Termination.ReadOnly]
    def getTermination
        : ZIO[Any, AwsError, zio.aws.chime.model.Termination.ReadOnly] =
      AwsError.unwrapOptionField("termination", termination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetVoiceConnectorTerminationResponse
  ) extends zio.aws.chime.model.GetVoiceConnectorTerminationResponse.ReadOnly {
    override val termination
        : Optional[zio.aws.chime.model.Termination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.termination())
        .map(value => zio.aws.chime.model.Termination.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetVoiceConnectorTerminationResponse
  ): zio.aws.chime.model.GetVoiceConnectorTerminationResponse.ReadOnly =
    new Wrapper(impl)
}
