package zio.aws.chime.model
import zio.aws.chime.model.primitives.{ResourceName, ChimeArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Identity(
    arn: Optional[ChimeArn] = Optional.Absent,
    name: Optional[ResourceName] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.chime.model.Identity = {
    import Identity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.Identity
      .builder()
      .optionallyWith(
        arn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.Identity.ReadOnly =
    zio.aws.chime.model.Identity.wrap(buildAwsValue())
}
object Identity {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.chime.model.Identity] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.Identity = zio.aws.chime.model
      .Identity(arn.map(value => value), name.map(value => value))
    def arn: Optional[ChimeArn]
    def name: Optional[ResourceName]
    def getArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.Identity
  ) extends zio.aws.chime.model.Identity.ReadOnly {
    override val arn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.chime.model.primitives.ResourceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.Identity
  ): zio.aws.chime.model.Identity.ReadOnly = new Wrapper(impl)
}
