package zio.aws.chime.model
import zio.aws.chime.model.primitives.EmailAddress
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Invite(
    inviteId: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.chime.model.InviteStatus] = Optional.Absent,
    emailAddress: Optional[EmailAddress] = Optional.Absent,
    emailStatus: Optional[zio.aws.chime.model.EmailStatus] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.chime.model.Invite = {
    import Invite.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.Invite
      .builder()
      .optionallyWith(inviteId.map(value => value: java.lang.String))(
        _.inviteId
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        emailAddress.map(value => EmailAddress.unwrap(value): java.lang.String)
      )(_.emailAddress)
      .optionallyWith(emailStatus.map(value => value.unwrap))(_.emailStatus)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.Invite.ReadOnly =
    zio.aws.chime.model.Invite.wrap(buildAwsValue())
}
object Invite {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.chime.model.Invite] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.Invite = zio.aws.chime.model.Invite(
      inviteId.map(value => value),
      status.map(value => value),
      emailAddress.map(value => value),
      emailStatus.map(value => value)
    )
    def inviteId: Optional[String]
    def status: Optional[zio.aws.chime.model.InviteStatus]
    def emailAddress: Optional[EmailAddress]
    def emailStatus: Optional[zio.aws.chime.model.EmailStatus]
    def getInviteId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("inviteId", inviteId)
    def getStatus: ZIO[Any, AwsError, zio.aws.chime.model.InviteStatus] =
      AwsError.unwrapOptionField("status", status)
    def getEmailAddress: ZIO[Any, AwsError, EmailAddress] =
      AwsError.unwrapOptionField("emailAddress", emailAddress)
    def getEmailStatus: ZIO[Any, AwsError, zio.aws.chime.model.EmailStatus] =
      AwsError.unwrapOptionField("emailStatus", emailStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.Invite
  ) extends zio.aws.chime.model.Invite.ReadOnly {
    override val inviteId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.inviteId())
      .map(value => value: String)
    override val status: Optional[zio.aws.chime.model.InviteStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.chime.model.InviteStatus.wrap(value))
    override val emailAddress: Optional[EmailAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.emailAddress())
      .map(value => zio.aws.chime.model.primitives.EmailAddress(value))
    override val emailStatus: Optional[zio.aws.chime.model.EmailStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.emailStatus())
        .map(value => zio.aws.chime.model.EmailStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.Invite
  ): zio.aws.chime.model.Invite.ReadOnly = new Wrapper(impl)
}
