package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait InviteStatus {
  def unwrap: software.amazon.awssdk.services.chime.model.InviteStatus
}
object InviteStatus {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.InviteStatus
  ): zio.aws.chime.model.InviteStatus = value match {
    case software.amazon.awssdk.services.chime.model.InviteStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.InviteStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.chime.model.InviteStatus.ACCEPTED =>
      val r = Accepted
      r
    case software.amazon.awssdk.services.chime.model.InviteStatus.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion extends zio.aws.chime.model.InviteStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.InviteStatus =
      software.amazon.awssdk.services.chime.model.InviteStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Pending extends zio.aws.chime.model.InviteStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.InviteStatus =
      software.amazon.awssdk.services.chime.model.InviteStatus.PENDING
  }
  case object Accepted extends zio.aws.chime.model.InviteStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.InviteStatus =
      software.amazon.awssdk.services.chime.model.InviteStatus.ACCEPTED
  }
  case object Failed extends zio.aws.chime.model.InviteStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.InviteStatus =
      software.amazon.awssdk.services.chime.model.InviteStatus.FAILED
  }
}
