package zio.aws.chime.model
import zio.aws.chime.model.primitives.{EmailAddress, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InviteUsersRequest(
    accountId: NonEmptyString,
    userEmailList: Iterable[EmailAddress],
    userType: Optional[zio.aws.chime.model.UserType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.InviteUsersRequest = {
    import InviteUsersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.InviteUsersRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .userEmailList(userEmailList.map { item =>
        EmailAddress.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(userType.map(value => value.unwrap))(_.userType)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.InviteUsersRequest.ReadOnly =
    zio.aws.chime.model.InviteUsersRequest.wrap(buildAwsValue())
}
object InviteUsersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.InviteUsersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.InviteUsersRequest =
      zio.aws.chime.model.InviteUsersRequest(
        accountId,
        userEmailList,
        userType.map(value => value)
      )
    def accountId: NonEmptyString
    def userEmailList: List[EmailAddress]
    def userType: Optional[zio.aws.chime.model.UserType]
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
    def getUserEmailList: ZIO[Any, Nothing, List[EmailAddress]] =
      ZIO.succeed(userEmailList)
    def getUserType: ZIO[Any, AwsError, zio.aws.chime.model.UserType] =
      AwsError.unwrapOptionField("userType", userType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.InviteUsersRequest
  ) extends zio.aws.chime.model.InviteUsersRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
    override val userEmailList: List[EmailAddress] = impl
      .userEmailList()
      .asScala
      .map { item =>
        zio.aws.chime.model.primitives.EmailAddress(item)
      }
      .toList
    override val userType: Optional[zio.aws.chime.model.UserType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userType())
        .map(value => zio.aws.chime.model.UserType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.InviteUsersRequest
  ): zio.aws.chime.model.InviteUsersRequest.ReadOnly = new Wrapper(impl)
}
