package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InviteUsersResponse(
    invites: Optional[Iterable[zio.aws.chime.model.Invite]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.InviteUsersResponse = {
    import InviteUsersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.InviteUsersResponse
      .builder()
      .optionallyWith(
        invites.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.invites)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.InviteUsersResponse.ReadOnly =
    zio.aws.chime.model.InviteUsersResponse.wrap(buildAwsValue())
}
object InviteUsersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.InviteUsersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.InviteUsersResponse =
      zio.aws.chime.model.InviteUsersResponse(
        invites.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def invites: Optional[List[zio.aws.chime.model.Invite.ReadOnly]]
    def getInvites
        : ZIO[Any, AwsError, List[zio.aws.chime.model.Invite.ReadOnly]] =
      AwsError.unwrapOptionField("invites", invites)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.InviteUsersResponse
  ) extends zio.aws.chime.model.InviteUsersResponse.ReadOnly {
    override val invites: Optional[List[zio.aws.chime.model.Invite.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invites())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.Invite.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.InviteUsersResponse
  ): zio.aws.chime.model.InviteUsersResponse.ReadOnly = new Wrapper(impl)
}
