package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait License {
  def unwrap: software.amazon.awssdk.services.chime.model.License
}
object License {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.License
  ): zio.aws.chime.model.License = value match {
    case software.amazon.awssdk.services.chime.model.License.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.License.BASIC =>
      val r = Basic
      r
    case software.amazon.awssdk.services.chime.model.License.PLUS =>
      val r = Plus
      r
    case software.amazon.awssdk.services.chime.model.License.PRO =>
      val r = Pro
      r
    case software.amazon.awssdk.services.chime.model.License.PRO_TRIAL =>
      val r = ProTrial
      r
  }
  case object unknownToSdkVersion extends zio.aws.chime.model.License {
    override def unwrap: software.amazon.awssdk.services.chime.model.License =
      software.amazon.awssdk.services.chime.model.License.UNKNOWN_TO_SDK_VERSION
  }
  case object Basic extends zio.aws.chime.model.License {
    override def unwrap: software.amazon.awssdk.services.chime.model.License =
      software.amazon.awssdk.services.chime.model.License.BASIC
  }
  case object Plus extends zio.aws.chime.model.License {
    override def unwrap: software.amazon.awssdk.services.chime.model.License =
      software.amazon.awssdk.services.chime.model.License.PLUS
  }
  case object Pro extends zio.aws.chime.model.License {
    override def unwrap: software.amazon.awssdk.services.chime.model.License =
      software.amazon.awssdk.services.chime.model.License.PRO
  }
  case object ProTrial extends zio.aws.chime.model.License {
    override def unwrap: software.amazon.awssdk.services.chime.model.License =
      software.amazon.awssdk.services.chime.model.License.PRO_TRIAL
  }
}
