package zio.aws.chime.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.{
  ProfileServiceMaxResults,
  EmailAddress,
  AccountName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAccountsRequest(
    name: Optional[AccountName] = Optional.Absent,
    userEmail: Optional[EmailAddress] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[ProfileServiceMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListAccountsRequest = {
    import ListAccountsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListAccountsRequest
      .builder()
      .optionallyWith(
        name.map(value => AccountName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        userEmail.map(value => EmailAddress.unwrap(value): java.lang.String)
      )(_.userEmail)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => ProfileServiceMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ListAccountsRequest.ReadOnly =
    zio.aws.chime.model.ListAccountsRequest.wrap(buildAwsValue())
}
object ListAccountsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListAccountsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListAccountsRequest =
      zio.aws.chime.model.ListAccountsRequest(
        name.map(value => value),
        userEmail.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def name: Optional[AccountName]
    def userEmail: Optional[EmailAddress]
    def nextToken: Optional[String]
    def maxResults: Optional[ProfileServiceMaxResults]
    def getName: ZIO[Any, AwsError, AccountName] =
      AwsError.unwrapOptionField("name", name)
    def getUserEmail: ZIO[Any, AwsError, EmailAddress] =
      AwsError.unwrapOptionField("userEmail", userEmail)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ProfileServiceMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListAccountsRequest
  ) extends zio.aws.chime.model.ListAccountsRequest.ReadOnly {
    override val name: Optional[AccountName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.chime.model.primitives.AccountName(value))
    override val userEmail: Optional[EmailAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.userEmail())
      .map(value => zio.aws.chime.model.primitives.EmailAddress(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[ProfileServiceMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.chime.model.primitives.ProfileServiceMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListAccountsRequest
  ): zio.aws.chime.model.ListAccountsRequest.ReadOnly = new Wrapper(impl)
}
