package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAccountsResponse(
    accounts: Optional[Iterable[zio.aws.chime.model.Account]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListAccountsResponse = {
    import ListAccountsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListAccountsResponse
      .builder()
      .optionallyWith(
        accounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accounts)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ListAccountsResponse.ReadOnly =
    zio.aws.chime.model.ListAccountsResponse.wrap(buildAwsValue())
}
object ListAccountsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListAccountsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListAccountsResponse =
      zio.aws.chime.model.ListAccountsResponse(
        accounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def accounts: Optional[List[zio.aws.chime.model.Account.ReadOnly]]
    def nextToken: Optional[String]
    def getAccounts
        : ZIO[Any, AwsError, List[zio.aws.chime.model.Account.ReadOnly]] =
      AwsError.unwrapOptionField("accounts", accounts)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListAccountsResponse
  ) extends zio.aws.chime.model.ListAccountsResponse.ReadOnly {
    override val accounts
        : Optional[List[zio.aws.chime.model.Account.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.Account.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListAccountsResponse
  ): zio.aws.chime.model.ListAccountsResponse.ReadOnly = new Wrapper(impl)
}
