package zio.aws.chime.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.{NextToken, MaxResults, ChimeArn}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAppInstanceAdminsRequest(
    appInstanceArn: ChimeArn,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListAppInstanceAdminsRequest = {
    import ListAppInstanceAdminsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListAppInstanceAdminsRequest
      .builder()
      .appInstanceArn(ChimeArn.unwrap(appInstanceArn): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ListAppInstanceAdminsRequest.ReadOnly =
    zio.aws.chime.model.ListAppInstanceAdminsRequest.wrap(buildAwsValue())
}
object ListAppInstanceAdminsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListAppInstanceAdminsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListAppInstanceAdminsRequest =
      zio.aws.chime.model.ListAppInstanceAdminsRequest(
        appInstanceArn,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def appInstanceArn: ChimeArn
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getAppInstanceArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(appInstanceArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListAppInstanceAdminsRequest
  ) extends zio.aws.chime.model.ListAppInstanceAdminsRequest.ReadOnly {
    override val appInstanceArn: ChimeArn =
      zio.aws.chime.model.primitives.ChimeArn(impl.appInstanceArn())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.chime.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.chime.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListAppInstanceAdminsRequest
  ): zio.aws.chime.model.ListAppInstanceAdminsRequest.ReadOnly = new Wrapper(
    impl
  )
}
