package zio.aws.chime.model
import zio.aws.chime.model.primitives.{NextToken, ChimeArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAppInstanceAdminsResponse(
    appInstanceArn: Optional[ChimeArn] = Optional.Absent,
    appInstanceAdmins: Optional[
      Iterable[zio.aws.chime.model.AppInstanceAdminSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListAppInstanceAdminsResponse = {
    import ListAppInstanceAdminsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListAppInstanceAdminsResponse
      .builder()
      .optionallyWith(
        appInstanceArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.appInstanceArn)
      .optionallyWith(
        appInstanceAdmins.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.appInstanceAdmins)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ListAppInstanceAdminsResponse.ReadOnly =
    zio.aws.chime.model.ListAppInstanceAdminsResponse.wrap(buildAwsValue())
}
object ListAppInstanceAdminsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListAppInstanceAdminsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListAppInstanceAdminsResponse =
      zio.aws.chime.model.ListAppInstanceAdminsResponse(
        appInstanceArn.map(value => value),
        appInstanceAdmins.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def appInstanceArn: Optional[ChimeArn]
    def appInstanceAdmins
        : Optional[List[zio.aws.chime.model.AppInstanceAdminSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getAppInstanceArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("appInstanceArn", appInstanceArn)
    def getAppInstanceAdmins: ZIO[Any, AwsError, List[
      zio.aws.chime.model.AppInstanceAdminSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("appInstanceAdmins", appInstanceAdmins)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListAppInstanceAdminsResponse
  ) extends zio.aws.chime.model.ListAppInstanceAdminsResponse.ReadOnly {
    override val appInstanceArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.appInstanceArn())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
    override val appInstanceAdmins
        : Optional[List[zio.aws.chime.model.AppInstanceAdminSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appInstanceAdmins())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.AppInstanceAdminSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.chime.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListAppInstanceAdminsResponse
  ): zio.aws.chime.model.ListAppInstanceAdminsResponse.ReadOnly = new Wrapper(
    impl
  )
}
