package zio.aws.chime.model
import zio.aws.chime.model.primitives.{NextToken, ChimeArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAppInstanceUsersResponse(
    appInstanceArn: Optional[ChimeArn] = Optional.Absent,
    appInstanceUsers: Optional[
      Iterable[zio.aws.chime.model.AppInstanceUserSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListAppInstanceUsersResponse = {
    import ListAppInstanceUsersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListAppInstanceUsersResponse
      .builder()
      .optionallyWith(
        appInstanceArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.appInstanceArn)
      .optionallyWith(
        appInstanceUsers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.appInstanceUsers)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ListAppInstanceUsersResponse.ReadOnly =
    zio.aws.chime.model.ListAppInstanceUsersResponse.wrap(buildAwsValue())
}
object ListAppInstanceUsersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListAppInstanceUsersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListAppInstanceUsersResponse =
      zio.aws.chime.model.ListAppInstanceUsersResponse(
        appInstanceArn.map(value => value),
        appInstanceUsers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def appInstanceArn: Optional[ChimeArn]
    def appInstanceUsers
        : Optional[List[zio.aws.chime.model.AppInstanceUserSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getAppInstanceArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("appInstanceArn", appInstanceArn)
    def getAppInstanceUsers: ZIO[Any, AwsError, List[
      zio.aws.chime.model.AppInstanceUserSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("appInstanceUsers", appInstanceUsers)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListAppInstanceUsersResponse
  ) extends zio.aws.chime.model.ListAppInstanceUsersResponse.ReadOnly {
    override val appInstanceArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.appInstanceArn())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
    override val appInstanceUsers
        : Optional[List[zio.aws.chime.model.AppInstanceUserSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appInstanceUsers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.AppInstanceUserSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.chime.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListAppInstanceUsersResponse
  ): zio.aws.chime.model.ListAppInstanceUsersResponse.ReadOnly = new Wrapper(
    impl
  )
}
