package zio.aws.chime.model
import zio.aws.chime.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAppInstancesResponse(
    appInstances: Optional[Iterable[zio.aws.chime.model.AppInstanceSummary]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListAppInstancesResponse = {
    import ListAppInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListAppInstancesResponse
      .builder()
      .optionallyWith(
        appInstances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.appInstances)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ListAppInstancesResponse.ReadOnly =
    zio.aws.chime.model.ListAppInstancesResponse.wrap(buildAwsValue())
}
object ListAppInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListAppInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListAppInstancesResponse =
      zio.aws.chime.model.ListAppInstancesResponse(
        appInstances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def appInstances
        : Optional[List[zio.aws.chime.model.AppInstanceSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getAppInstances: ZIO[Any, AwsError, List[
      zio.aws.chime.model.AppInstanceSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("appInstances", appInstances)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListAppInstancesResponse
  ) extends zio.aws.chime.model.ListAppInstancesResponse.ReadOnly {
    override val appInstances
        : Optional[List[zio.aws.chime.model.AppInstanceSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appInstances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.AppInstanceSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.chime.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListAppInstancesResponse
  ): zio.aws.chime.model.ListAppInstancesResponse.ReadOnly = new Wrapper(impl)
}
