package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAttendeeTagsResponse(
    tags: Optional[Iterable[zio.aws.chime.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListAttendeeTagsResponse = {
    import ListAttendeeTagsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListAttendeeTagsResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ListAttendeeTagsResponse.ReadOnly =
    zio.aws.chime.model.ListAttendeeTagsResponse.wrap(buildAwsValue())
}
object ListAttendeeTagsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListAttendeeTagsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListAttendeeTagsResponse =
      zio.aws.chime.model.ListAttendeeTagsResponse(
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def tags: Optional[List[zio.aws.chime.model.Tag.ReadOnly]]
    def getTags: ZIO[Any, AwsError, List[zio.aws.chime.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListAttendeeTagsResponse
  ) extends zio.aws.chime.model.ListAttendeeTagsResponse.ReadOnly {
    override val tags: Optional[List[zio.aws.chime.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListAttendeeTagsResponse
  ): zio.aws.chime.model.ListAttendeeTagsResponse.ReadOnly = new Wrapper(impl)
}
