package zio.aws.chime.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.{ResultMax, GuidString}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAttendeesRequest(
    meetingId: GuidString,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[ResultMax] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListAttendeesRequest = {
    import ListAttendeesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListAttendeesRequest
      .builder()
      .meetingId(GuidString.unwrap(meetingId): java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => ResultMax.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ListAttendeesRequest.ReadOnly =
    zio.aws.chime.model.ListAttendeesRequest.wrap(buildAwsValue())
}
object ListAttendeesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListAttendeesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListAttendeesRequest =
      zio.aws.chime.model.ListAttendeesRequest(
        meetingId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def meetingId: GuidString
    def nextToken: Optional[String]
    def maxResults: Optional[ResultMax]
    def getMeetingId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(meetingId)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ResultMax] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListAttendeesRequest
  ) extends zio.aws.chime.model.ListAttendeesRequest.ReadOnly {
    override val meetingId: GuidString =
      zio.aws.chime.model.primitives.GuidString(impl.meetingId())
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[ResultMax] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.chime.model.primitives.ResultMax(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListAttendeesRequest
  ): zio.aws.chime.model.ListAttendeesRequest.ReadOnly = new Wrapper(impl)
}
