package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAttendeesResponse(
    attendees: Optional[Iterable[zio.aws.chime.model.Attendee]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListAttendeesResponse = {
    import ListAttendeesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListAttendeesResponse
      .builder()
      .optionallyWith(
        attendees.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attendees)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ListAttendeesResponse.ReadOnly =
    zio.aws.chime.model.ListAttendeesResponse.wrap(buildAwsValue())
}
object ListAttendeesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListAttendeesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListAttendeesResponse =
      zio.aws.chime.model.ListAttendeesResponse(
        attendees.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def attendees: Optional[List[zio.aws.chime.model.Attendee.ReadOnly]]
    def nextToken: Optional[String]
    def getAttendees
        : ZIO[Any, AwsError, List[zio.aws.chime.model.Attendee.ReadOnly]] =
      AwsError.unwrapOptionField("attendees", attendees)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListAttendeesResponse
  ) extends zio.aws.chime.model.ListAttendeesResponse.ReadOnly {
    override val attendees
        : Optional[List[zio.aws.chime.model.Attendee.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attendees())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.Attendee.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListAttendeesResponse
  ): zio.aws.chime.model.ListAttendeesResponse.ReadOnly = new Wrapper(impl)
}
