package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListBotsResponse(
    bots: Optional[Iterable[zio.aws.chime.model.Bot]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListBotsResponse = {
    import ListBotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListBotsResponse
      .builder()
      .optionallyWith(
        bots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.bots)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ListBotsResponse.ReadOnly =
    zio.aws.chime.model.ListBotsResponse.wrap(buildAwsValue())
}
object ListBotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListBotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListBotsResponse =
      zio.aws.chime.model.ListBotsResponse(
        bots.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def bots: Optional[List[zio.aws.chime.model.Bot.ReadOnly]]
    def nextToken: Optional[String]
    def getBots: ZIO[Any, AwsError, List[zio.aws.chime.model.Bot.ReadOnly]] =
      AwsError.unwrapOptionField("bots", bots)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListBotsResponse
  ) extends zio.aws.chime.model.ListBotsResponse.ReadOnly {
    override val bots: Optional[List[zio.aws.chime.model.Bot.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bots())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.Bot.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListBotsResponse
  ): zio.aws.chime.model.ListBotsResponse.ReadOnly = new Wrapper(impl)
}
