package zio.aws.chime.model
import zio.aws.chime.model.primitives.{NextToken, ChimeArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListChannelBansResponse(
    channelArn: Optional[ChimeArn] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    channelBans: Optional[Iterable[zio.aws.chime.model.ChannelBanSummary]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListChannelBansResponse = {
    import ListChannelBansResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListChannelBansResponse
      .builder()
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        channelBans.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.channelBans)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ListChannelBansResponse.ReadOnly =
    zio.aws.chime.model.ListChannelBansResponse.wrap(buildAwsValue())
}
object ListChannelBansResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListChannelBansResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListChannelBansResponse =
      zio.aws.chime.model.ListChannelBansResponse(
        channelArn.map(value => value),
        nextToken.map(value => value),
        channelBans.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def channelArn: Optional[ChimeArn]
    def nextToken: Optional[NextToken]
    def channelBans
        : Optional[List[zio.aws.chime.model.ChannelBanSummary.ReadOnly]]
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getChannelBans: ZIO[Any, AwsError, List[
      zio.aws.chime.model.ChannelBanSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("channelBans", channelBans)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListChannelBansResponse
  ) extends zio.aws.chime.model.ListChannelBansResponse.ReadOnly {
    override val channelArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.chime.model.primitives.NextToken(value))
    override val channelBans
        : Optional[List[zio.aws.chime.model.ChannelBanSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channelBans())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.ChannelBanSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListChannelBansResponse
  ): zio.aws.chime.model.ListChannelBansResponse.ReadOnly = new Wrapper(impl)
}
