package zio.aws.chime.model
import zio.aws.chime.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListChannelMembershipsForAppInstanceUserResponse(
    channelMemberships: Optional[
      Iterable[zio.aws.chime.model.ChannelMembershipForAppInstanceUserSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListChannelMembershipsForAppInstanceUserResponse = {
    import ListChannelMembershipsForAppInstanceUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListChannelMembershipsForAppInstanceUserResponse
      .builder()
      .optionallyWith(
        channelMemberships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.channelMemberships)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.ListChannelMembershipsForAppInstanceUserResponse.ReadOnly =
    zio.aws.chime.model.ListChannelMembershipsForAppInstanceUserResponse
      .wrap(buildAwsValue())
}
object ListChannelMembershipsForAppInstanceUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListChannelMembershipsForAppInstanceUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.ListChannelMembershipsForAppInstanceUserResponse =
      zio.aws.chime.model.ListChannelMembershipsForAppInstanceUserResponse(
        channelMemberships.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def channelMemberships: Optional[List[
      zio.aws.chime.model.ChannelMembershipForAppInstanceUserSummary.ReadOnly
    ]]
    def nextToken: Optional[NextToken]
    def getChannelMemberships: ZIO[Any, AwsError, List[
      zio.aws.chime.model.ChannelMembershipForAppInstanceUserSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("channelMemberships", channelMemberships)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListChannelMembershipsForAppInstanceUserResponse
  ) extends zio.aws.chime.model.ListChannelMembershipsForAppInstanceUserResponse.ReadOnly {
    override val channelMemberships: Optional[List[
      zio.aws.chime.model.ChannelMembershipForAppInstanceUserSummary.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.channelMemberships())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chime.model.ChannelMembershipForAppInstanceUserSummary
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.chime.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListChannelMembershipsForAppInstanceUserResponse
  ): zio.aws.chime.model.ListChannelMembershipsForAppInstanceUserResponse.ReadOnly =
    new Wrapper(impl)
}
