package zio.aws.chime.model
import zio.aws.chime.model.primitives.{NextToken, ChimeArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListChannelMembershipsResponse(
    channelArn: Optional[ChimeArn] = Optional.Absent,
    channelMemberships: Optional[
      Iterable[zio.aws.chime.model.ChannelMembershipSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListChannelMembershipsResponse = {
    import ListChannelMembershipsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListChannelMembershipsResponse
      .builder()
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(
        channelMemberships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.channelMemberships)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ListChannelMembershipsResponse.ReadOnly =
    zio.aws.chime.model.ListChannelMembershipsResponse.wrap(buildAwsValue())
}
object ListChannelMembershipsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListChannelMembershipsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListChannelMembershipsResponse =
      zio.aws.chime.model.ListChannelMembershipsResponse(
        channelArn.map(value => value),
        channelMemberships.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def channelArn: Optional[ChimeArn]
    def channelMemberships
        : Optional[List[zio.aws.chime.model.ChannelMembershipSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getChannelMemberships: ZIO[Any, AwsError, List[
      zio.aws.chime.model.ChannelMembershipSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("channelMemberships", channelMemberships)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListChannelMembershipsResponse
  ) extends zio.aws.chime.model.ListChannelMembershipsResponse.ReadOnly {
    override val channelArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
    override val channelMemberships: Optional[
      List[zio.aws.chime.model.ChannelMembershipSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.channelMemberships())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chime.model.ChannelMembershipSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.chime.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListChannelMembershipsResponse
  ): zio.aws.chime.model.ListChannelMembershipsResponse.ReadOnly = new Wrapper(
    impl
  )
}
