package zio.aws.chime.model
import zio.aws.chime.model.primitives.{NextToken, ChimeArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListChannelMessagesResponse(
    channelArn: Optional[ChimeArn] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    channelMessages: Optional[
      Iterable[zio.aws.chime.model.ChannelMessageSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListChannelMessagesResponse = {
    import ListChannelMessagesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListChannelMessagesResponse
      .builder()
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        channelMessages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.channelMessages)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ListChannelMessagesResponse.ReadOnly =
    zio.aws.chime.model.ListChannelMessagesResponse.wrap(buildAwsValue())
}
object ListChannelMessagesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListChannelMessagesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListChannelMessagesResponse =
      zio.aws.chime.model.ListChannelMessagesResponse(
        channelArn.map(value => value),
        nextToken.map(value => value),
        channelMessages.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def channelArn: Optional[ChimeArn]
    def nextToken: Optional[NextToken]
    def channelMessages
        : Optional[List[zio.aws.chime.model.ChannelMessageSummary.ReadOnly]]
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getChannelMessages: ZIO[Any, AwsError, List[
      zio.aws.chime.model.ChannelMessageSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("channelMessages", channelMessages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListChannelMessagesResponse
  ) extends zio.aws.chime.model.ListChannelMessagesResponse.ReadOnly {
    override val channelArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.chime.model.primitives.NextToken(value))
    override val channelMessages
        : Optional[List[zio.aws.chime.model.ChannelMessageSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channelMessages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.ChannelMessageSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListChannelMessagesResponse
  ): zio.aws.chime.model.ListChannelMessagesResponse.ReadOnly = new Wrapper(
    impl
  )
}
