package zio.aws.chime.model
import zio.aws.chime.model.primitives.{NextToken, ChimeArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListChannelModeratorsResponse(
    channelArn: Optional[ChimeArn] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    channelModerators: Optional[
      Iterable[zio.aws.chime.model.ChannelModeratorSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListChannelModeratorsResponse = {
    import ListChannelModeratorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListChannelModeratorsResponse
      .builder()
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        channelModerators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.channelModerators)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ListChannelModeratorsResponse.ReadOnly =
    zio.aws.chime.model.ListChannelModeratorsResponse.wrap(buildAwsValue())
}
object ListChannelModeratorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListChannelModeratorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListChannelModeratorsResponse =
      zio.aws.chime.model.ListChannelModeratorsResponse(
        channelArn.map(value => value),
        nextToken.map(value => value),
        channelModerators.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def channelArn: Optional[ChimeArn]
    def nextToken: Optional[NextToken]
    def channelModerators
        : Optional[List[zio.aws.chime.model.ChannelModeratorSummary.ReadOnly]]
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getChannelModerators: ZIO[Any, AwsError, List[
      zio.aws.chime.model.ChannelModeratorSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("channelModerators", channelModerators)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListChannelModeratorsResponse
  ) extends zio.aws.chime.model.ListChannelModeratorsResponse.ReadOnly {
    override val channelArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.chime.model.primitives.NextToken(value))
    override val channelModerators
        : Optional[List[zio.aws.chime.model.ChannelModeratorSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channelModerators())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.ChannelModeratorSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListChannelModeratorsResponse
  ): zio.aws.chime.model.ListChannelModeratorsResponse.ReadOnly = new Wrapper(
    impl
  )
}
